/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.syncing.ui.wizards;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.syncing.ui.wizards.Messages;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportConnectionsPage
extends WizardPage {
    private Button workspaceButton;
    private Button fileButton;
    private Text filePathText;
    private Button browseButton;

    protected ImportConnectionsPage() {
        super("importConnections");
    }

    public boolean isWorkspaceSelected() {
        return this.workspaceButton.getSelection();
    }

    public IPath getLocation() {
        return Path.fromOSString((String)this.filePathText.getText());
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite sourceType = new Composite(main, 0);
        sourceType.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        sourceType.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label label = new Label(sourceType, 0);
        label.setText(Messages.ImportConnectionsPage_LBL_SourceType);
        this.workspaceButton = new Button(sourceType, 16);
        this.workspaceButton.setText(Messages.ImportConnectionsPage_SourceType_Workspace);
        this.workspaceButton.setSelection(true);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportConnectionsPage.this.validate();
            }
        };
        this.workspaceButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fileButton = new Button(sourceType, 16);
        this.fileButton.setText(Messages.ImportConnectionsPage_SourceType_File);
        this.fileButton.addSelectionListener((SelectionListener)selectionAdapter);
        Composite source = new Composite(main, 0);
        source.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        source.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        label = new Label(source, 0);
        label.setText(Messages.ImportConnectionsPage_LBL_Path);
        this.filePathText = new Text(source, 2048);
        this.filePathText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.filePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportConnectionsPage.this.validate();
            }
        });
        this.browseButton = new Button(source, 8);
        this.browseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportConnectionsPage.this.browse();
            }
        });
        this.setTitle(Messages.ImportConnectionsPage_Title);
        this.setDescription(Messages.ImportConnectionsPage_Description);
        this.setControl((Control)main);
        this.validate();
    }

    private void browse() {
        String result = null;
        if (this.workspaceButton.getSelection()) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            result = dialog.open();
        } else {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            result = dialog.open();
        }
        if (result != null) {
            this.filePathText.setText(result);
            this.validate();
        }
    }

    private void validate() {
        String error = null;
        String path = this.filePathText.getText();
        if (StringUtil.isEmpty((String)path)) {
            error = Messages.ImportConnectionsPage_ERR_EmptyPath;
        } else {
            File file = new File(path);
            if (!file.exists()) {
                error = Messages.ImportConnectionsPage_ERR_InvalidPath;
            } else if (this.workspaceButton.getSelection() && !file.isDirectory()) {
                error = Messages.ImportConnectionsPage_ERR_InvalidDirectory;
            } else if (this.fileButton.getSelection() && file.isDirectory()) {
                error = Messages.ImportConnectionsPage_ERR_InvalidFile;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

